In addition to being able to specify different commands on different operating systems, Bonnie also allows the specification of custom shells to execute commands in (e.g. `sh`, `bash`, `cmd`, `powershell`).

```toml
version = "0.3.2"

[scripts]
test.cmd.exec = "echo Test"
test.cmd.shell = [ "bash", "-c", "{COMMAND}" ]
```

```
bonnie test	# Test
```

Custom shells are specified using the `.shell` property under `.cmd`. Because `.cmd` can be scoped to different OSes, you can easily run different commands in different shells on different OSes! The actual command to execute goes under `.cmd.exec` (which can be either a string or an array of course).

Shells are specified slightly oddly in Bonnie, as arrays. This is because the way we're all used to of running commands, that is using spaces between 'words', is actually an invention of a shell! In reality, commands are composed of an executable and arguments to that executable. For flexibility, Rust (the language Bonnie is programmed in) and Bonnie replicate this pattern. This means that you don't have to enclose arguments to shells in quotation marks, in fact that can cause problems! The first element in the array is the name of the executable on your system (e.g. `bash`), and the rest are arguments to it.

It should be noted that it is entirely optional to set shells, and is only really needed if there are specific features of a particular shell that you want to use. If you don't specify a shell for a command, the default shell will be used (which can be changed on a per-file basis, you can read more [here](./Changing-the-Default-Shell)). If no file default is specified, the global Bonnie default will be used. Those are listed for different systems below.

To specify the location in the shell to insert the command into, use the `{COMMAND}` token. Do NOT put quotation marks around this, the entire command will be considered an executable, and you'll get an error like `couldn't find executable 'echo Test'`!

In [multistage commands](./Multistage-Commands), stages are chained together using a delimiter like `&&`, which can be specified for a shell using the following syntax:

```toml
{ parts = [ "sh", "-c", "{COMMAND}" ], delimiter = " || " }
```

The above example would change the behavior of the shell in question so that multistage commands would execute in series, and the next stage would run only if the previous one fails (that's what `||` means in `sh`). **If a delimiter is not specified, `&&` will be used**, except in the Windows PowerShell default, which uses `;`.

The default shells for Bonnie are listed below for different OSes:

- Windows `powershell -command {COMMAND}` (delimiter `;`)
- MacOS `sh -c {COMMAND}` (delimiter `&&`)
- Linux `sh -c {COMMAND}` (delimiter `&&`)

On any other OS, `sh -c {COMMAND}` will be used as the fallback (with delimiter `&&`). Please [open an issue](https://github.com/arctic-hen7/bonnie/issues/new/choose) if you'd like more/better defaults to be added for different OSes!

**The default Bonnie shell on Windows is PowerShell, not CMD after v0.3.0!** However, before v0.3.0, it was `cmd`. See [here](./Changing-the-Default-Shell) for how to change that on a per-file basis.
